#!/bin/bash
    #
    # This script is an example for running DELWAQ D-Water Quality
    # Adapt and use it for your own purpose
    #
    # michel.jeuken@deltares.nl
    # 11 Mrt 2013
    # 
    #
    # This script starts 3D DELWAQ D-Water Quality computation on Linux
    #


    #
    # Set the config file here
    # 
inpfile=50x10_multilayer.inp

currentdir=`pwd`
echo $currentdir
argfile=$currentdir/$inpfile

    #
    # Set the directory containing delwaq1 and delwaq2 and
    # the directory containing the proc_def and bloom files here
    #
exedir=$currentdir/../../../../../../../home/delft3d/7545/bin/lnx64/waq/bin
filedir=$currentdir/../../../../../../../home
export LD_LIBRARY_PATH=$exedir:$LD_LIBRARY_PATH
procfile=$filedir/delft3d/7545/bin/lnx64/waq/default/proc_def
ecofile=$filedir/delft3d/7545/bin/lnx64/waq/default/bloom.spe

    #
    # Run delwaq 1
    #
$exedir/delwaq1 $argfile -eco $ecofile -p "$procfile"
    #
    # Wait for any key to run delwaq 2
    #
if [ $? == 0 ]
  then
    echo ""
    echo "Delwaq1 did run without errors."

    #
    # Run delwaq 2
    #
    echo ""
    $exedir/delwaq2 $argfile

    if [ $? -eq 0 ]
      then
        echo ""
        echo "Delwaq2 did run without errors."
      else
        echo ""
        echo "Delwaq2 did not run correctly."
    fi
else
    echo ""
    echo "Delwaq1 did not run correctly, ending calculation"
fi
